"""Store settings"""

from MaxIcsRegistry import MaxIcsRegistry

class Settings:

    """Settings"""
    def __init__(self, staging: bool = False, registry=None) -> None:

        if not registry:
            registry = MaxIcsRegistry.from_env(staging=staging)

        building_center_info = registry.get_info("building-knowledge-information-center")

        self.api_key = building_center_info["api_in"][registry.node_id]["key"]
        self.base_url = "http://{}:{}/api/buildings/".format(
            building_center_info["service_addr"], building_center_info["service_port"]
        )
