"""Different utils used for logging for example"""

import os
import logging
import logging.config
import yaml


def setup_logging(default_path="logging.yaml", default_level=logging.INFO, env_key="LOG_CFG"):
    """Setup logging configuration

    :param default_path: ogging config file, defaults to "logging.yaml"
    :type default_path: str, optional
    :param default_level: detail level for the logger, defaults to logging.INFO
    :type default_level: str, optional
    :param env_key: Configuration key, defaults to "LOG_CFG"
    :type env_key: str, optional
    """
    path = os.getenv(env_key, default_path)
    if os.path.exists(path):
        with open(path, "rt") as config_file:
            config = yaml.safe_load(config_file.read())
        logging.config.dictConfig(config)
    else:
        logging.basicConfig(level=default_level)
    logging.getLogger("azure.core.pipeline.policies.http_logging_policy").setLevel(logging.WARNING)